CREATE OR REPLACE FUNCTION addColumn() RETURNS VOID AS $BODY$
BEGIN
    IF EXISTS (SELECT 1 FROM information_schema.columns
                    WHERE table_name= 'est_fisco_env'
                         and column_name='sts_ultimo_env') THEN

        RAISE NOTICE 'Coluna "sts_ultimo_env" na tabela "est_fisco_env" ja existe!' ;

    ELSE
		ALTER TABLE est_fisco_env ADD sts_ultimo_env numeric NULL;
        RAISE NOTICE 'Coluna "sts_ultimo_env" criada com sucesso!';
    END IF;
	
	IF EXISTS (SELECT 1 FROM information_schema.columns
                    WHERE table_name= 'est_fisco_env'
                         and column_name='ultima_msg') THEN

        RAISE NOTICE 'Coluna "ultima_msg" na tabela "est_fisco_env" ja existe!' ;

    ELSE
		ALTER TABLE est_fisco_env ADD ultima_msg varchar(250) NULL;
        RAISE NOTICE 'Coluna "ultima_msg" criada com sucesso!';
    END IF;

END;
-- fim bloco principal
$BODY$ LANGUAGE PLPGSQL VOLATILE COST 100;


ALTER FUNCTION addColumn() OWNER TO postgres;
SELECT addColumn();
DROP FUNCTION addColumn();